<?php defined('BASEPATH') OR exit('No direct script access allowed');
require_once APPPATH.'libraries/DaaS_REST_Controller.php';
	
	class Disclosure extends DaaS_REST_Controller{
		function __construct() {
			parent::__construct();
			if (!$this->request->disclosure_api_authorized) { //authorize request
				$this->response( 'Access Denied. Use Not Authorized.', 403);
			}
		
		}
		public function audit_get() {
			$this->load->model('accountingdisclosuremodel');
			$optional_fields = array('first','last','ssn','start','end');
			
			//set variables for each optional field
			foreach($optional_fields as $optional_field){
				$$optional_field = element($optional_field, $this->get(), null); //checks to see if $field is in $get - if not, sets to null
			}
			if($start && !is_numeric($start)){
				array_push($this->invalid_fields, 'start');
			}
			if($end && !is_numeric($end)){
				array_push($this->invalid_fields, 'end');
			}
			if($ssn && !is_numeric($ssn)){
				array_push($this->invalid_fields, 'ssn');
			}
			//TODO put invalid ssn when we figure out what format it is in
			$this->respond_with_error_if_fields_are_invalid();
			$request = $this->accountingdisclosuremodel->get_request($first,$last,$ssn,$start,$end);
			if($request){
				$logs = $request->result();
				$this->response($logs,200);
			}
			else{
				$this->response('Failed to get disclosure log.', 500);
			}
		}
		
	}